/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mx_dma_map_h_
#define _mx_dma_map_h_

#include <asm/atomic.h>

/* Powerpc64 returns a -1 for error when using pci_map_single (0 might
   be a valid dma address) Every other architecture either uses 0 or
   never fails
*/

#if MX_CPU_powerpc64  
#define INVALID_DMA_ADDR ((dma_addr_t)-1)
#else
#define INVALID_DMA_ADDR ((dma_addr_t)0)
#endif

static inline int
mx_dma_map(mx_instance_state_t *is, struct page *page, mcp_dma_addr_t *dma)
{
  dma_addr_t bus;

  if (!is->arch.has_iommu || atomic_read (&is->arch.free_iommu_pages) > 0) {
    bus = pci_map_page (is->arch.pci_dev, page, 0, PAGE_SIZE,
			PCI_DMA_BIDIRECTIONAL);
    if (is->arch.has_iommu && bus != INVALID_DMA_ADDR) {
      atomic_dec (&is->arch.free_iommu_pages);
    }
  } else {
    mx_printf_once("Warning: iommu allocation exhausted\n");
    return ENOMEM;
  }
  if (bus == INVALID_DMA_ADDR) {
    mx_printf_once("Warning:pci_map failure: should be free=%d pages\n",
		   atomic_read(&is->arch.free_iommu_pages));
    return ENXIO;
  } 
  dma->low = MX_LOWPART_TO_U32(bus);
  dma->high = MX_HIGHPART_TO_U32(bus);

  return 0;
}

static inline void
mx_dma_unmap (mx_instance_state_t *is, mcp_dma_addr_t *dma)
{
  
  dma_addr_t bus;
  
  bus = (dma_addr_t)dma->low;
  bus |=  MX_U32_TO_HIGHPART(dma->high, bus);
  
  if (is->arch.has_iommu) {
    atomic_inc(&is->arch.free_iommu_pages);
  }
  pci_unmap_page(is->arch.pci_dev,(dma_addr_t) bus, PAGE_SIZE,
		 PCI_DMA_BIDIRECTIONAL);
}

#endif /* _mx_dma_map_h_ */
